console.log("Gamble Galaxy content script loaded on YouTube!");

chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.action === "show_modal") {
    console.log("Received show_modal message");

    if (document.getElementById('gg-modal')) return;

    const modal = document.createElement('div');
    modal.id = 'gg-modal';
    modal.style.position = 'fixed';
    modal.style.top = '50%';
    modal.style.left = '50%';
    modal.style.transform = 'translate(-50%, -50%)';
    modal.style.background = '#1e1e1e';
    modal.style.color = '#f0f0f0';
    modal.style.border = '2px solid #333';
    modal.style.zIndex = '9999';
    modal.style.padding = '20px';
    modal.style.width = '320px';
    modal.style.boxShadow = '0 0 20px rgba(0,0,0,0.7)';
    modal.style.borderRadius = '8px';
    modal.style.fontFamily = 'Arial, sans-serif';

    modal.innerHTML = `
      <h3 style="margin-top:0;">Post to Gamble Galaxy</h3>
      <input type="text" id="gg-title" placeholder="Title (max 40 chars)" maxlength="40" style="width:100%; padding:8px; margin-bottom:10px; border:1px solid #555; background:#2b2b2b; color:#f0f0f0; border-radius:4px;" />
      <textarea id="gg-message" placeholder="Message..." style="width:100%; height:80px; padding:8px; border:1px solid #555; background:#2b2b2b; color:#f0f0f0; border-radius:4px; margin-bottom:10px;"></textarea>
      <button id="gg-post" style="background:#4caf50; color:#fff; border:none; padding:8px 12px; border-radius:4px; cursor:pointer;">Post</button>
      <button id="gg-close" style="background:#444; color:#fff; border:none; padding:8px 12px; border-radius:4px; float:right; cursor:pointer;">Close</button>
    `;

    document.body.appendChild(modal);

    document.getElementById('gg-title').value = message.title?.slice(0, 40) || '';
    document.getElementById('gg-message').value = message.url || '';

    document.getElementById('gg-close').addEventListener('click', () => {
      modal.remove();
    });

    document.getElementById('gg-post').addEventListener('click', () => {
      const title = document.getElementById('gg-title').value.trim();
      const msg = document.getElementById('gg-message').value.trim();

      if (!msg) {
        alert("Message required!");
        return;
      }

      chrome.runtime.sendMessage(
        {
          action: "post_to_gamble_galaxy",
          title: title,
          message: msg
        },
        (response) => {
          if (response.success) {
            alert("Post created!");
            modal.remove();
          } else {
            alert("Error: " + response.error);
          }
        }
      );
    });
  }
});
